/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.sql;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.libs.org.apache.commons.dbcp.BasicDataSource;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsData;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.backends.SchemaUpdate;
import ru.tehkode.permissions.backends.caching.CachingGroupData;
import ru.tehkode.permissions.backends.caching.CachingUserData;
import ru.tehkode.permissions.backends.sql.SQLConnection;
import ru.tehkode.permissions.backends.sql.SQLData;
import ru.tehkode.permissions.backends.sql.SQLQueryCache;
import ru.tehkode.permissions.exceptions.PermissionBackendException;
import ru.tehkode.utils.StringUtils;

public class SQLBackend
extends PermissionBackend {
    protected Map<String, List<String>> worldInheritanceCache;
    private final AtomicReference<ImmutableSet<String>> userNamesCache;
    private final AtomicReference<ImmutableSet<String>> groupNamesCache;
    private Map<String, Object> tableNames;
    private SQLQueryCache queryCache;
    private static final SQLQueryCache DEFAULT_QUERY_CACHE;
    private BasicDataSource ds;
    protected final String dbDriver;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLBackend(PermissionManager manager, ConfigurationSection config) throws PermissionBackendException {
        Throwable throwable;
        SQLConnection conn;
        block36: {
            super(manager, config);
            this.worldInheritanceCache = new HashMap<String, List<String>>();
            this.userNamesCache = new AtomicReference();
            this.groupNamesCache = new AtomicReference();
            String dbUri = this.getConfig().getString("uri", "");
            String dbUser = this.getConfig().getString("user", "");
            String dbPassword = this.getConfig().getString("password", "");
            if (dbUri == null || dbUri.isEmpty()) {
                this.getConfig().set("uri", (Object)"mysql://localhost/exampledb");
                this.getConfig().set("user", (Object)"databaseuser");
                this.getConfig().set("password", (Object)"databasepassword");
                manager.getConfiguration().save();
                throw new PermissionBackendException("SQL connection is not configured, see config.yml");
            }
            this.dbDriver = dbUri.split(":", 2)[0];
            this.ds = new BasicDataSource();
            String driverClass = SQLBackend.getDriverClass(this.dbDriver);
            if (driverClass != null) {
                this.ds.setDriverClassName(driverClass);
            }
            this.ds.setUrl("jdbc:" + dbUri);
            this.ds.setUsername(dbUser);
            this.ds.setPassword(dbPassword);
            this.ds.setMaxActive(Runtime.getRuntime().availableProcessors() * 2 + 1);
            this.ds.setMaxWait(200L);
            this.ds.setValidationQuery("SELECT 1 AS dbcp_validate");
            this.ds.setTestOnBorrow(true);
            InputStream queryLocation = this.getClass().getResourceAsStream("/sql/" + this.dbDriver + "/queries.properties");
            if (queryLocation != null) {
                try {
                    this.queryCache = new SQLQueryCache(queryLocation, DEFAULT_QUERY_CACHE);
                }
                catch (IOException e) {
                    throw new PermissionBackendException("Unable to access database-specific queries", e);
                }
            } else {
                this.queryCache = DEFAULT_QUERY_CACHE;
            }
            try {
                block37: {
                    conn = this.getSQL();
                    throwable = null;
                    try {
                        conn.checkConnection();
                        if (conn == null) break block36;
                        if (throwable == null) break block37;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (conn == null) throw throwable4;
                            if (throwable == null) {
                                conn.close();
                                throw throwable4;
                            }
                            try {
                                conn.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                try {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable4;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                            break block36;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block36;
                }
                conn.close();
            }
            catch (Exception e) {
                if (e.getCause() == null) throw new PermissionBackendException("Unable to connect to SQL database", e);
                if (!(e.getCause() instanceof Exception)) throw new PermissionBackendException("Unable to connect to SQL database", e);
                e = (Exception)e.getCause();
                throw new PermissionBackendException("Unable to connect to SQL database", e);
            }
        }
        this.getManager().getLogger().info("Successfully connected to SQL database");
        this.addSchemaUpdate(new SchemaUpdate(2){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void performUpdate() throws PermissionBackendException {
                try {
                    SQLConnection conn;
                    block15: {
                        conn = SQLBackend.this.getSQL();
                        Throwable throwable = null;
                        try {
                            conn.prep("ALTER TABLE `{permissions}` DROP KEY `unique`, MODIFY COLUMN `permission` TEXT NOT NULL").execute();
                            if (conn == null) return;
                            if (throwable == null) break block15;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (conn == null) throw throwable4;
                                if (throwable == null) {
                                    conn.close();
                                    throw throwable4;
                                }
                                try {
                                    conn.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    try {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        throw throwable4;
                                    }
                                }
                            }
                        }
                        try {
                            conn.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable.addSuppressed(throwable2);
                                return;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                return;
                            }
                        }
                    }
                    conn.close();
                    return;
                }
                catch (IOException | SQLException e) {
                    throw new PermissionBackendException(e);
                }
            }
        });
        this.addSchemaUpdate(new SchemaUpdate(1){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void performUpdate() throws PermissionBackendException {
                try {
                    SQLConnection conn;
                    block16: {
                        conn = SQLBackend.this.getSQL();
                        Throwable throwable = null;
                        try {
                            PreparedStatement updateStmt = conn.prep("entity.options.add");
                            ResultSet res = conn.prepAndBind("SELECT `name`, `type` FROM `{permissions_entity}` WHERE `default`='1'", new Object[0]).executeQuery();
                            while (res.next()) {
                                conn.bind(updateStmt, res.getString("name"), res.getInt("type"), "default", "", "true");
                                updateStmt.addBatch();
                            }
                            updateStmt.executeBatch();
                            conn.prep("ALTER TABLE `{permissions_entity}` DROP COLUMN `default`").execute();
                            if (conn == null) return;
                            if (throwable == null) break block16;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (conn == null) throw throwable4;
                                if (throwable == null) {
                                    conn.close();
                                    throw throwable4;
                                }
                                try {
                                    conn.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    try {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        throw throwable4;
                                    }
                                }
                            }
                        }
                        try {
                            conn.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable.addSuppressed(throwable2);
                                return;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                return;
                            }
                        }
                    }
                    conn.close();
                    return;
                }
                catch (IOException | SQLException e) {
                    throw new PermissionBackendException(e);
                }
            }
        });
        this.addSchemaUpdate(new SchemaUpdate(0){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void performUpdate() throws PermissionBackendException {
                try {
                    SQLConnection conn;
                    block17: {
                        conn = SQLBackend.this.getSQL();
                        Throwable throwable = null;
                        try {
                            PreparedStatement updateStmt = conn.prep("entity.options.add");
                            ResultSet res = conn.prepAndBind("SELECT `name`, `type`, `prefix`, `suffix` FROM `{permissions_entity}` WHERE LENGTH(`prefix`)>0 OR LENGTH(`suffix`)>0", new Object[0]).executeQuery();
                            while (res.next()) {
                                String suffix;
                                String prefix = res.getString("prefix");
                                if (!prefix.isEmpty() && !prefix.equals("null")) {
                                    conn.bind(updateStmt, res.getString("name"), res.getInt("type"), "prefix", "", prefix);
                                    updateStmt.addBatch();
                                }
                                if ((suffix = res.getString("suffix")).isEmpty() || suffix.equals("null")) continue;
                                conn.bind(updateStmt, res.getString("name"), res.getInt("type"), "suffix", "", suffix);
                                updateStmt.addBatch();
                            }
                            updateStmt.executeBatch();
                            conn.prep("ALTER TABLE `{permissions_entity}` DROP KEY `name`").execute();
                            conn.prep("ALTER TABLE `{permissions_entity}` DROP COLUMN `prefix`, DROP COLUMN `suffix`").execute();
                            conn.prep("ALTER TABLE `{permissions_entity}` ADD CONSTRAINT UNIQUE KEY `name` (`name`, `type`)").execute();
                            conn.prep("ALTER TABLE `{permissions}` DROP KEY `unique`").execute();
                            conn.prep("ALTER TABLE `{permissions}` ADD CONSTRAINT UNIQUE `unique` (`name`,`permission`,`world`,`type`)").execute();
                            if (conn == null) return;
                            if (throwable == null) break block17;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (conn == null) throw throwable4;
                                if (throwable == null) {
                                    conn.close();
                                    throw throwable4;
                                }
                                try {
                                    conn.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    try {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        throw throwable4;
                                    }
                                }
                            }
                        }
                        try {
                            conn.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable.addSuppressed(throwable2);
                                return;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                return;
                            }
                        }
                    }
                    conn.close();
                    return;
                }
                catch (IOException | SQLException e) {
                    throw new PermissionBackendException(e);
                }
            }
        });
        this.setupAliases();
        this.deployTables();
        this.performSchemaUpdate();
        try {
            block38: {
                conn = this.getSQL();
                throwable = null;
                try {
                    conn.prep("ALTER TABLE `{permissions}` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci").execute();
                    conn.prep("ALTER TABLE `{permissions_entity}` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci").execute();
                    conn.prep("ALTER TABLE `{permissions_inheritance}` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci").execute();
                    if (conn == null) return;
                    if (throwable == null) break block38;
                }
                catch (Throwable throwable7) {
                    try {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        if (conn == null) throw throwable8;
                        if (throwable == null) {
                            conn.close();
                            throw throwable8;
                        }
                        try {
                            conn.close();
                            throw throwable8;
                        }
                        catch (Throwable throwable9) {
                            try {
                                throwable.addSuppressed(throwable9);
                                throw throwable8;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable8;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable6) {
                    try {
                        throwable.addSuppressed(throwable6);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int getSchemaVersion() {
        int n;
        Throwable throwable;
        SQLConnection conn;
        block27: {
            block28: {
                ResultSet res;
                block24: {
                    int n2;
                    block25: {
                        block26: {
                            conn = this.getSQL();
                            throwable = null;
                            res = conn.prepAndBind("entity.options.get", "system", SQLData.Type.WORLD.ordinal(), "schema_version", "").executeQuery();
                            if (res.next()) break block24;
                            n2 = -1;
                            if (conn == null) break block25;
                            if (throwable == null) break block26;
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable.addSuppressed(throwable2);
                                    break block25;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {}
                            }
                            break block25;
                        }
                        conn.close();
                    }
                    return n2;
                }
                n = res.getInt("value");
                if (conn == null) break block27;
                if (throwable == null) break block28;
                try {
                    conn.close();
                }
                catch (Throwable throwable3) {
                    try {
                        throwable.addSuppressed(throwable3);
                        break block27;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {}
                }
                break block27;
            }
            conn.close();
        }
        return n;
        {
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (conn != null) {
                            if (throwable != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable6) {
                                    try {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                }
                            } else {
                                conn.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (IOException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void setSchemaVersion(int version) {
        try {
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    conn.prepAndBind("entity.options.delete", "system", "schema_version", SQLData.Type.WORLD.ordinal(), "").execute();
                    conn.prepAndBind("entity.options.add", "system", SQLData.Type.WORLD.ordinal(), "schema_version", "", version).execute();
                    if (conn == null) return;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    SQLQueryCache getQueryCache() {
        return this.queryCache;
    }

    protected static String getDriverClass(String alias) {
        if (alias.equals("mysql")) {
            return "com.mysql.jdbc.Driver";
        }
        if (alias.equals("sqlite")) {
            return "org.sqlite.JDBC";
        }
        if (alias.matches("postgres?")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    public SQLConnection getSQL() throws SQLException {
        if (this.ds == null) {
            throw new SQLException("SQL connection information was not correct, could not retrieve connection");
        }
        return new SQLConnection(this.ds.getConnection(), this);
    }

    public String getTableName(String identifier) {
        Map<String, Object> tableNames = this.tableNames;
        if (tableNames == null) {
            return identifier;
        }
        Object ret = tableNames.get(identifier);
        if (ret == null) {
            return identifier;
        }
        return ret.toString();
    }

    @Override
    public PermissionsUserData getUserData(String name) {
        CachingUserData data = new CachingUserData(new SQLData(name, SQLData.Type.USER, this), this.getExecutor(), new Object());
        this.updateNameCache(this.userNamesCache, data);
        return data;
    }

    @Override
    public PermissionsGroupData getGroupData(String name) {
        CachingGroupData data = new CachingGroupData(new SQLData(name, SQLData.Type.GROUP, this), this.getExecutor(), new Object());
        this.updateNameCache(this.groupNamesCache, data);
        return data;
    }

    private void updateNameCache(AtomicReference<ImmutableSet<String>> list, PermissionsData data) {
        ImmutableSet<String> newVal;
        ImmutableSet<String> cache;
        do {
            newVal = cache = list.get();
            if (cache != null && (cache.contains((Object)data.getIdentifier()) || data.isVirtual())) continue;
            newVal = null;
        } while (!list.compareAndSet(cache, newVal));
    }

    void updateNameCache(SQLData data) {
        AtomicReference<ImmutableSet<String>> ref;
        switch (data.getType()) {
            case USER: {
                ref = this.userNamesCache;
                break;
            }
            case GROUP: {
                ref = this.groupNamesCache;
                break;
            }
            default: {
                return;
            }
        }
        this.updateNameCache(ref, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImmutableSet<String> getEntityNames(AtomicReference<ImmutableSet<String>> cacheRef, SQLData.Type type) {
        ImmutableSet<String> cache;
        while ((cache = cacheRef.get()) == null) {
            try {
                Throwable throwable;
                SQLConnection conn;
                block22: {
                    ImmutableSet immutableSet;
                    block23: {
                        conn = this.getSQL();
                        throwable = null;
                        try {
                            ImmutableSet newCache = ImmutableSet.copyOf(SQLData.getEntitiesNames(conn, type, false));
                            if (!cacheRef.compareAndSet(null, (ImmutableSet<String>)newCache)) break block22;
                            immutableSet = newCache;
                            if (conn == null) return immutableSet;
                            if (throwable == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (conn == null) throw throwable3;
                                if (throwable == null) {
                                    conn.close();
                                    throw throwable3;
                                }
                                try {
                                    conn.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    try {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        throw throwable3;
                                    }
                                }
                            }
                        }
                        try {
                            conn.close();
                            return immutableSet;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                return immutableSet;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                return immutableSet;
                            }
                        }
                    }
                    conn.close();
                    return immutableSet;
                }
                if (conn == null) continue;
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable6) {
                        try {
                            throwable.addSuppressed(throwable6);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    continue;
                }
                conn.close();
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return cache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasUser(String userName) {
        try {
            boolean bl;
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("entity.exists", userName, SQLData.Type.USER.ordinal()).executeQuery();
                    bl = res.next();
                    if (conn == null) return bl;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return bl;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return bl;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return bl;
                    }
                }
            }
            conn.close();
            return bl;
        }
        catch (IOException | SQLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasGroup(String group) {
        try {
            boolean bl;
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("entity.exists", group, SQLData.Type.GROUP.ordinal()).executeQuery();
                    bl = res.next();
                    if (conn == null) return bl;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return bl;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return bl;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return bl;
                    }
                }
            }
            conn.close();
            return bl;
        }
        catch (IOException | SQLException e) {
            return false;
        }
    }

    @Override
    public Collection<String> getGroupNames() {
        return this.getEntityNames(this.groupNamesCache, SQLData.Type.GROUP);
    }

    @Override
    public Collection<String> getUserIdentifiers() {
        return this.getEntityNames(this.userNamesCache, SQLData.Type.USER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getUserNames() {
        HashSet<String> ret = new HashSet<String>();
        try {
            SQLConnection conn;
            block16: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet set = conn.prepAndBind("SELECT `value` FROM `{permissions}` WHERE `type` = ? AND `permission` = 'name' AND `value` IS NOT NULL", SQLData.Type.USER.ordinal()).executeQuery();
                    while (set.next()) {
                        ret.add(set.getString("value"));
                    }
                    if (conn == null) return Collections.unmodifiableSet(ret);
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableSet(ret);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return Collections.unmodifiableSet(ret);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableSet(ret);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableSet(ret);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void setupAliases() {
        ConfigurationSection aliases = this.getConfig().getConfigurationSection("aliases");
        if (aliases == null) {
            return;
        }
        this.tableNames = aliases.getValues(false);
    }

    private void executeStream(SQLConnection conn, InputStream str) throws SQLException, IOException {
        String deploySQL = StringUtils.readStream(str);
        Statement s = conn.getStatement();
        for (String sqlQuery : deploySQL.trim().split(";")) {
            if ((sqlQuery = sqlQuery.trim()).isEmpty()) continue;
            sqlQuery = conn.expandQuery(sqlQuery + ";");
            s.addBatch(sqlQuery);
        }
        s.executeBatch();
    }

    /*
     * Loose catch block
     */
    protected final void deployTables() throws PermissionBackendException {
        block26: {
            try {
                Throwable throwable;
                SQLConnection conn;
                block27: {
                    block23: {
                        block24: {
                            block25: {
                                conn = this.getSQL();
                                throwable = null;
                                if (!conn.hasTable("{permissions}") || !conn.hasTable("{permissions_entity}") || !conn.hasTable("{permissions_inheritance}")) break block23;
                                if (conn == null) break block24;
                                if (throwable == null) break block25;
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable.addSuppressed(throwable2);
                                        break block24;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                }
                                break block24;
                            }
                            conn.close();
                        }
                        return;
                    }
                    InputStream databaseDumpStream = this.getClass().getResourceAsStream("/sql/" + this.dbDriver + "/deploy.sql");
                    if (databaseDumpStream == null) {
                        throw new Exception("Can't find appropriate database dump for used database (" + this.dbDriver + "). Is it bundled?");
                    }
                    this.getLogger().info("Deploying default database scheme");
                    this.executeStream(conn, databaseDumpStream);
                    this.setSchemaVersion(this.getLatestSchemaVersion());
                    if (conn == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable.addSuppressed(throwable3);
                            break block26;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block26;
                }
                conn.close();
                break block26;
                catch (Throwable throwable4) {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (conn != null) {
                            if (throwable != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable6) {
                                    try {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                }
                            } else {
                                conn.close();
                            }
                        }
                        throw throwable5;
                    }
                }
            }
            catch (Exception e) {
                throw new PermissionBackendException("Deploying of default data failed. Please initialize database manually using " + this.dbDriver + ".sql", e);
            }
        }
        PermissionsGroupData defGroup = this.getGroupData("default");
        defGroup.setPermissions(Collections.singletonList("modifyworld.*"), null);
        defGroup.setOption("default", "true", null);
        defGroup.save();
        this.getLogger().info("Database scheme deploying complete.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getWorldInheritance(String world) {
        if (world == null) return Collections.emptyList();
        if (world.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.worldInheritanceCache.containsKey(world)) return this.worldInheritanceCache.get(world);
        try {
            SQLConnection conn;
            block17: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = conn.prepAndBind("SELECT `parent` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ?;", world, SQLData.Type.WORLD.ordinal()).executeQuery();
                    LinkedList<String> worldParents = new LinkedList<String>();
                    while (result.next()) {
                        worldParents.add(result.getString("parent"));
                    }
                    this.worldInheritanceCache.put(world, Collections.unmodifiableList(worldParents));
                    if (conn == null) return this.worldInheritanceCache.get(world);
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return this.worldInheritanceCache.get(world);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return this.worldInheritanceCache.get(world);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return this.worldInheritanceCache.get(world);
                    }
                }
            }
            conn.close();
            return this.worldInheritanceCache.get(world);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> getAllWorldInheritance() {
        try {
            Map<String, List<String>> map;
            SQLConnection conn;
            block16: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = conn.prepAndBind("SELECT `child` FROM `{permissions_inheritance}` WHERE `type` = ?", SQLData.Type.WORLD.ordinal()).executeQuery();
                    HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
                    while (result.next()) {
                        String world = result.getString("child");
                        if (ret.containsKey(world)) continue;
                        ret.put(world, this.getWorldInheritance(world));
                    }
                    map = Collections.unmodifiableMap(ret);
                    if (conn == null) return map;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return map;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return map;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return map;
                    }
                }
            }
            conn.close();
            return map;
        }
        catch (IOException | SQLException e) {
            return Collections.unmodifiableMap(this.worldInheritanceCache);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setWorldInheritance(String worldName, List<String> parentWorlds) {
        if (worldName == null) return;
        if (worldName.isEmpty()) {
            return;
        }
        try {
            SQLConnection conn;
            block17: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    conn.prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ?", worldName, SQLData.Type.WORLD.ordinal()).execute();
                    PreparedStatement statement = conn.prepAndBind("INSERT INTO `{permissions_inheritance}` (`child`, `parent`, `type`) VALUES (?, ?, ?)", worldName, "toset", SQLData.Type.WORLD.ordinal());
                    for (String parentWorld : parentWorlds) {
                        statement.setString(2, parentWorld);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    this.worldInheritanceCache.put(worldName, parentWorlds);
                    if (conn == null) return;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reload() {
        this.worldInheritanceCache.clear();
        this.userNamesCache.set(null);
        this.groupNamesCache.set(null);
    }

    @Override
    public void setPersistent(boolean persist) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeContents(Writer writer) throws IOException {
        try {
            SQLConnection conn;
            block15: {
                conn = this.getSQL();
                Throwable throwable = null;
                try {
                    this.writeTable("permissions", conn, writer);
                    this.writeTable("permissions_entity", conn, writer);
                    this.writeTable("permissions_inheritance", conn, writer);
                    if (conn == null) return;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private void writeTable(String table, SQLConnection conn, Writer writer) throws IOException, SQLException {
        ResultSet res = conn.prep("SHOW CREATE TABLE `{" + table + "}`").executeQuery();
        if (!res.next()) {
            throw new IOException("No value for table create for table " + table);
        }
        writer.write(res.getString(2));
        writer.write(";\n");
        res = conn.prep("SELECT * FROM `{" + table + "}`").executeQuery();
        while (res.next()) {
            writer.write("INSERT INTO `{");
            writer.write(table);
            writer.write("}` VALUES (");
            for (int i = 1; i <= res.getMetaData().getColumnCount(); ++i) {
                Class<?> columnClazz;
                String value = res.getString(i);
                try {
                    columnClazz = Class.forName(res.getMetaData().getColumnClassName(i));
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
                if (value == null) {
                    value = "null";
                } else if (String.class.equals(columnClazz)) {
                    value = "'" + value + "'";
                }
                writer.write(value);
                if (i == res.getMetaData().getColumnCount()) {
                    writer.write(");\n");
                    continue;
                }
                writer.write(", ");
            }
        }
        writer.write(10);
    }

    @Override
    public void close() throws PermissionBackendException {
        super.close();
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (SQLException e) {
                throw new PermissionBackendException("Error while closing", e);
            }
        }
    }

    static {
        try {
            DEFAULT_QUERY_CACHE = new SQLQueryCache(SQLBackend.class.getResourceAsStream("/sql/default/queries.properties"), null);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

