/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import com.zachsthings.netevents.NetEventsPlugin;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class RemoteEventListener
implements Listener {
    private final NetEventsPlugin netEvents;
    private final PermissionManager manager;

    public RemoteEventListener(NetEventsPlugin netEvents, PermissionManager manager) {
        this.netEvents = netEvents;
        this.manager = manager;
    }

    public boolean isLocal(PermissionEvent event) {
        return this.netEvents == null || event.getSourceUUID().equals(this.netEvents.getServerUUID());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityEvent(PermissionEntityEvent event) {
        boolean reloadEntity;
        boolean reloadAll;
        if (this.isLocal(event)) {
            return;
        }
        switch (event.getAction()) {
            case DEFAULTGROUP_CHANGED: 
            case RANK_CHANGED: 
            case INHERITANCE_CHANGED: {
                reloadAll = true;
                reloadEntity = false;
                break;
            }
            case SAVED: 
            case TIMEDPERMISSION_EXPIRED: {
                return;
            }
            default: {
                reloadEntity = true;
                reloadAll = false;
            }
        }
        try {
            if (reloadEntity) {
                if (this.manager.getBackend() != null) {
                    this.manager.getBackend().reload();
                }
                switch (event.getType()) {
                    case USER: {
                        this.manager.resetUser(event.getEntityIdentifier());
                        break;
                    }
                    case GROUP: {
                        PermissionGroup group = this.manager.resetGroup(event.getEntityIdentifier());
                        if (group == null) break;
                        for (PermissionUser user : group.getActiveUsers(true)) {
                            this.manager.resetUser(user.getIdentifier());
                        }
                        break;
                    }
                }
            } else if (reloadAll) {
                this.manager.reset();
            }
        }
        catch (PermissionBackendException e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSystemEvent(PermissionSystemEvent event) {
        if (this.isLocal(event)) {
            return;
        }
        switch (event.getAction()) {
            case BACKEND_CHANGED: 
            case DEBUGMODE_TOGGLE: 
            case REINJECT_PERMISSIBLES: {
                return;
            }
        }
        try {
            this.manager.reset(false);
        }
        catch (PermissionBackendException e) {
            e.printStackTrace();
        }
    }
}

