/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.libs.org.apache.commons.dbcp.datasources;

import javax.naming.RefAddr;
import javax.naming.Reference;
import ru.tehkode.libs.org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import ru.tehkode.libs.org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import ru.tehkode.libs.org.apache.commons.dbcp.datasources.SharedPoolDataSource;

public class SharedPoolDataSourceFactory
extends InstanceKeyObjectFactory {
    private static final String SHARED_POOL_CLASSNAME = SharedPoolDataSource.class.getName();

    @Override
    protected boolean isCorrectClass(String className) {
        return SHARED_POOL_CLASSNAME.equals(className);
    }

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference ref) {
        SharedPoolDataSource spds = new SharedPoolDataSource();
        RefAddr ra = ref.get("maxActive");
        if (ra != null && ra.getContent() != null) {
            spds.setMaxActive(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxIdle")) != null && ra.getContent() != null) {
            spds.setMaxIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxWait")) != null && ra.getContent() != null) {
            spds.setMaxWait(Integer.parseInt(ra.getContent().toString()));
        }
        return spds;
    }
}

